(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12708,        443]*)
(*NotebookOutlinePosition[     18806,        600]*)
(*  CellTagsIndexPosition[     18562,        588]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Contact Information", "Chapter",
  CellTags->"ContactInformation"],

Cell["Main Web Sites", "Subsection",
  CellTags->{"ContactInformation", "web"}],

Cell[TextData[{
  ButtonBox["http://www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    FontColor->GrayLevel[0]],
  ButtonBox["http://www.wolfram.co.uk",
    ButtonData:>{
      URL[ "http://www.wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    FontColor->GrayLevel[0]],
  ButtonBox["http://www.wolfram.co.jp",
    ButtonData:>{
      URL[ "http://www.wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[
  "\n\nNote: All services listed are available at all of these sites.",
    FontColor->GrayLevel[0]]
}], "Compact12Text",
  CellTags->{"ContactInformation", "web"}],

Cell[TextData[{
  "Information about ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsection",
  CellTags->{"ContactInformation", "info"}],

Cell[TextData[StyleBox["General and sales information",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->{"ContactInformation", "info"}],

Cell[TextData[{
  ButtonBox["info@wolfram.com",
    ButtonData:>{
      URL[ "mailto: info@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"info"],

Cell[TextData[StyleBox["Frequently asked technical and other questions",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->"info"],

Cell[TextData[ButtonBox["http://www.wolfram.com/faq",
  ButtonData:>{
    URL[ "http://www.wolfram.com/faq"], None},
  ButtonStyle->"Hyperlink"]], "Compact12Text",
  CellTags->"info"],

Cell[TextData[StyleBox["Documentation updates",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->"info"],

Cell[TextData[ButtonBox["http://www.wolfram.com/book-updates",
  ButtonData:>{
    URL[ "http://www.wolfram.com/book-updates"], None},
  ButtonStyle->"Hyperlink"]], "Compact12Text",
  CellTags->"info"],

Cell["Services for Users", "Subsection",
  CellTags->{"ContactInformation", "services"}],

Cell[TextData[StyleBox["User registration and password requests",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->{"ContactInformation", "services"}],

Cell[TextData[{
  ButtonBox["register@wolfram.com",
    ButtonData:>{
      URL[ "mailto: register@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.wolfram.com/register",
    ButtonData:>{
      URL[ "http://www.wolfram.com/register"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"services"],

Cell[TextData[StyleBox["Technical support and bug reports",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->"services"],

Cell[TextData[{
  ButtonBox["support@wolfram.com",
    ButtonData:>{
      URL[ "mailto: support@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.wolfram.com/support",
    ButtonData:>{
      URL[ "http://www.wolfram.com/support"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"services"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" training information",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellTags->"services"],

Cell[TextData[{
  ButtonBox["training@wolfram.com",
    ButtonData:>{
      URL[ "mailto: training@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.wolfram.com/training",
    ButtonData:>{
      URL[ "http://www.wolfram.com/training"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"services"],

Cell[TextData[StyleBox["Comments and Feedback",
  FontSize->14,
  FontWeight->"Bold"]], "Subsection",
  CellTags->{"ContactInformation", "comments"}],

Cell[TextData[StyleBox["Suggestions",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->{"ContactInformation", "comments"}],

Cell[TextData[{
  ButtonBox["suggestions@wolfram.com",
    ButtonData:>{
      URL[ "mailto: suggestions@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.wolfram.com/suggestions",
    ButtonData:>{
      URL[ "http://www.wolfram.com/suggestions"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"comments"],

Cell[TextData[StyleBox["Bug reports",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->"comments"],

Cell[TextData[{
  ButtonBox["support@wolfram.com",
    ButtonData:>{
      URL[ "mailto: support@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.wolfram.com/support",
    ButtonData:>{
      URL[ "http://www.wolfram.com/support"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"comments"],

Cell[TextData[StyleBox["Comments and feedback",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->"comments"],

Cell[TextData[{
  ButtonBox["comments@wolfram.com",
    ButtonData:>{
      URL[ "mailto: comments@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.wolfram.com/comments",
    ButtonData:>{
      URL[ "http://www.wolfram.com/comments"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"comments"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Archive",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellTags->"comments"],

Cell[TextData[{
  "Publications and other non-proprietary  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " related materials are welcome at: \nThe ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Archive\nWolfram Research, Inc.\n100 Trade Center Drive\nChampaign, IL \
61820, USA\n\n",
  ButtonBox["archive@wolfram.com",
    ButtonData:>{
      URL[ "mailto: archive@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.wolfram.com/archive",
    ButtonData:>{
      URL[ "http://www.wolfram.com/archive"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"comments"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSize->14,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["-Related Products and Material",
    FontSize->14,
    FontWeight->"Bold"]
}], "Subsection",
  CellTags->{"ContactInformation", "products"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Products Catalog",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellTags->{"ContactInformation", "products"}],

Cell[TextData[ButtonBox["http://www.wolfram.com/catalog",
  ButtonData:>{
    URL[ "http://www.wolfram.com/catalog"], None},
  ButtonStyle->"Hyperlink"]], "Compact12Text",
  CellTags->"products"],

Cell[TextData[{
  StyleBox["The ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Book",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellTags->"products"],

Cell[TextData[{
  ButtonBox["bookstore-responder@wolfram.com",
    ButtonData:>{
      URL[ "mailto: bookstore-responder@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[".",
    FontSlant->"Italic"],
  "\n",
  ButtonBox["http://www.wolfram.com/book-updates",
    ButtonData:>{
      URL[ "http://www.wolfram.com/book-updates"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"products"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Bookstore",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellTags->"products"],

Cell[TextData[ButtonBox["http://www.wolfram.com/bookstore",
  ButtonData:>{
    URL[ "http://www.wolfram.com/bookstore"], None},
  ButtonStyle->"Hyperlink"]], "Compact12Text",
  CellTags->"products"],

Cell[TextData[{
  StyleBox["MathSource",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Electronic Library",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellTags->"products"],

Cell[TextData[{
  ButtonBox["http://www.wolfram.com/mathsource",
    ButtonData:>{
      URL[ "http://www.wolfram.com/mathsource"], None},
    ButtonStyle->"Hyperlink"],
  "\nftp: mathsource.wolfram.com\nmail server: ",
  ButtonBox["mathsource@wolfram.com",
    ButtonData:>{
      URL[ "mailto: mathsource@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\nadministrator: ",
  ButtonBox["mathsource-admin@wolfram.com",
    ButtonData:>{
      URL[ "mailto: mathsource-admin@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  " "
}], "Compact12Text",
  CellTags->"products"],

Cell[TextData[{
  StyleBox["MathUser ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Newsletter",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellTags->"products"],

Cell[TextData[{
  ButtonBox["http://www.wolfram.com/mathuser",
    ButtonData:>{
      URL[ "http://www.wolfram.com/mathuser"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["mathuser@wolfram.com",
    ButtonData:>{
      URL[ "mailto: mathuser@wolfram.com"], None},
    ButtonStyle->"Hyperlink"]
}], "Compact12Text",
  CellTags->"products"],

Cell[TextData[StyleBox["Company Addresses",
  FontSize->14,
  FontWeight->"Bold"]], "Subsection",
  CellTags->{"ContactInformation", "addresses"}],

Cell[TextData[StyleBox["Wolfram Research, Inc.",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]]], "Subsubsection",
  CellTags->{"ContactInformation", "addresses"}],

Cell[TextData[{
  StyleBox["100 Trade Center Drive\nChampaign, IL 61820\nUSA\nemail: ",
    FontColor->GrayLevel[0]],
  ButtonBox["info@wolfram.com",
    ButtonData:>{
      URL[ "mailto: info@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nphone: 217-398-0700\nfax: 217-398-0747",
    FontColor->GrayLevel[0]]
}], "Compact12Text",
  CellTags->"addresses"],

Cell["Wolfram Research Europe Ltd.", "Subsubsection",
  CellTags->"addresses"],

Cell[TextData[{
  StyleBox[
  "10 Blenheim Office Park\nLower Road, Long Hanborough\nOxfordshire OX8 8LN\n\
UNITED KINGDOM\nemail: ",
    FontColor->GrayLevel[0]],
  ButtonBox["info@wolfram.co.uk",
    ButtonData:>{
      URL[ "mailto: info@wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nphone: +44-(0)1993-883400\nfax: +44-(0)1993-883800",
    FontColor->GrayLevel[0]]
}], "Compact12Text",
  CellTags->"addresses"],

Cell[TextData[StyleBox["Wolfram Research Asia Ltd.",
  FontWeight->"Bold",
  FontColor->GrayLevel[0]]], "Subsubsection",
  CellTags->"addresses"],

Cell[TextData[{
  StyleBox[
  "Izumi Building 8F\n3-2-15 Misaki-cho\nChiyoda-ku, Tokyo 101\nJAPAN\nemail: \
 ",
    FontColor->GrayLevel[0]],
  ButtonBox["info@wolfram.co.jp",
    ButtonData:>{
      URL[ "mailto: info@wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nphone: +81-(0)3-5276-0506\nfax: +81-(0)3-5276-0509",
    FontColor->GrayLevel[0]],
  "\n"
}], "Compact12Text",
  CellTags->"addresses"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowToolbars->{},
WindowSize->{520, 365},
WindowMargins->{{3, Automatic}, {Automatic, 5}},
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ContactInformation"->{
    Cell[1709, 49, 72, 1, 55, "Chapter",
      CellTags->"ContactInformation"],
    Cell[1784, 52, 79, 1, 36, "Subsection",
      CellTags->{"ContactInformation", "web"}],
    Cell[1866, 55, 690, 21, 78, "Compact12Text",
      CellTags->{"ContactInformation", "web"}],
    Cell[2559, 78, 152, 5, 36, "Subsection",
      CellTags->{"ContactInformation", "info"}],
    Cell[2714, 85, 140, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "info"}],
    Cell[3820, 122, 88, 1, 36, "Subsection",
      CellTags->{"ContactInformation", "services"}],
    Cell[3911, 125, 154, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "services"}],
    Cell[5458, 181, 149, 3, 34, "Subsection",
      CellTags->{"ContactInformation", "comments"}],
    Cell[5610, 186, 126, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "comments"}],
    Cell[7864, 267, 262, 9, 34, "Subsection",
      CellTags->{"ContactInformation", "products"}],
    Cell[8129, 278, 216, 7, 33, "Subsubsection",
      CellTags->{"ContactInformation", "products"}],
    Cell[10917, 384, 146, 3, 34, "Subsection",
      CellTags->{"ContactInformation", "addresses"}],
    Cell[11066, 389, 165, 3, 33, "Subsubsection",
      CellTags->{"ContactInformation", "addresses"}]},
  "web"->{
    Cell[1784, 52, 79, 1, 36, "Subsection",
      CellTags->{"ContactInformation", "web"}],
    Cell[1866, 55, 690, 21, 78, "Compact12Text",
      CellTags->{"ContactInformation", "web"}]},
  "info"->{
    Cell[2559, 78, 152, 5, 36, "Subsection",
      CellTags->{"ContactInformation", "info"}],
    Cell[2714, 85, 140, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "info"}],
    Cell[2857, 89, 323, 11, 36, "Compact12Text",
      CellTags->"info"],
    Cell[3183, 102, 133, 2, 33, "Subsubsection",
      CellTags->"info"],
    Cell[3319, 106, 183, 4, 22, "Compact12Text",
      CellTags->"info"],
    Cell[3505, 112, 108, 2, 33, "Subsubsection",
      CellTags->"info"],
    Cell[3616, 116, 201, 4, 22, "Compact12Text",
      CellTags->"info"]},
  "services"->{
    Cell[3820, 122, 88, 1, 36, "Subsection",
      CellTags->{"ContactInformation", "services"}],
    Cell[3911, 125, 154, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "services"}],
    Cell[4068, 129, 353, 11, 36, "Compact12Text",
      CellTags->"services"],
    Cell[4424, 142, 124, 2, 33, "Subsubsection",
      CellTags->"services"],
    Cell[4551, 146, 349, 11, 36, "Compact12Text",
      CellTags->"services"],
    Cell[4903, 159, 196, 7, 33, "Subsubsection",
      CellTags->"services"],
    Cell[5102, 168, 353, 11, 36, "Compact12Text",
      CellTags->"services"]},
  "comments"->{
    Cell[5458, 181, 149, 3, 34, "Subsection",
      CellTags->{"ContactInformation", "comments"}],
    Cell[5610, 186, 126, 2, 33, "Subsubsection",
      CellTags->{"ContactInformation", "comments"}],
    Cell[5739, 190, 365, 11, 36, "Compact12Text",
      CellTags->"comments"],
    Cell[6107, 203, 102, 2, 33, "Subsubsection",
      CellTags->"comments"],
    Cell[6212, 207, 349, 11, 36, "Compact12Text",
      CellTags->"comments"],
    Cell[6564, 220, 112, 2, 33, "Subsubsection",
      CellTags->"comments"],
    Cell[6679, 224, 353, 11, 36, "Compact12Text",
      CellTags->"comments"],
    Cell[7035, 237, 183, 7, 33, "Subsubsection",
      CellTags->"comments"],
    Cell[7221, 246, 640, 19, 122, "Compact12Text",
      CellTags->"comments"]},
  "products"->{
    Cell[7864, 267, 262, 9, 34, "Subsection",
      CellTags->{"ContactInformation", "products"}],
    Cell[8129, 278, 216, 7, 33, "Subsubsection",
      CellTags->{"ContactInformation", "products"}],
    Cell[8348, 287, 195, 4, 22, "Compact12Text",
      CellTags->"products"],
    Cell[8546, 293, 224, 9, 33, "Subsubsection",
      CellTags->"products"],
    Cell[8773, 304, 425, 13, 37, "Compact12Text",
      CellTags->"products"],
    Cell[9201, 319, 185, 7, 33, "Subsubsection",
      CellTags->"products"],
    Cell[9389, 328, 199, 4, 22, "Compact12Text",
      CellTags->"products"],
    Cell[9591, 334, 193, 7, 33, "Subsubsection",
      CellTags->"products"],
    Cell[9787, 343, 585, 17, 64, "Compact12Text",
      CellTags->"products"],
    Cell[10375, 362, 183, 7, 33, "Subsubsection",
      CellTags->"products"],
    Cell[10561, 371, 353, 11, 36, "Compact12Text",
      CellTags->"products"]},
  "addresses"->{
    Cell[10917, 384, 146, 3, 34, "Subsection",
      CellTags->{"ContactInformation", "addresses"}],
    Cell[11066, 389, 165, 3, 33, "Subsubsection",
      CellTags->{"ContactInformation", "addresses"}],
    Cell[11234, 394, 375, 10, 92, "Compact12Text",
      CellTags->"addresses"],
    Cell[11612, 406, 78, 1, 33, "Subsubsection",
      CellTags->"addresses"],
    Cell[11693, 409, 437, 12, 106, "Compact12Text",
      CellTags->"addresses"],
    Cell[12133, 423, 145, 3, 33, "Subsubsection",
      CellTags->"addresses"],
    Cell[12281, 428, 423, 13, 120, "Compact12Text",
      CellTags->"addresses"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ContactInformation", 13563, 465},
  {"web", 14842, 492},
  {"info", 15044, 497},
  {"services", 15622, 512},
  {"comments", 16232, 527},
  {"products", 17001, 546},
  {"addresses", 17927, 569}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 72, 1, 55, "Chapter",
  CellTags->"ContactInformation"],
Cell[1784, 52, 79, 1, 36, "Subsection",
  CellTags->{"ContactInformation", "web"}],
Cell[1866, 55, 690, 21, 78, "Compact12Text",
  CellTags->{"ContactInformation", "web"}],
Cell[2559, 78, 152, 5, 36, "Subsection",
  CellTags->{"ContactInformation", "info"}],
Cell[2714, 85, 140, 2, 33, "Subsubsection",
  CellTags->{"ContactInformation", "info"}],
Cell[2857, 89, 323, 11, 36, "Compact12Text",
  CellTags->"info"],
Cell[3183, 102, 133, 2, 33, "Subsubsection",
  CellTags->"info"],
Cell[3319, 106, 183, 4, 22, "Compact12Text",
  CellTags->"info"],
Cell[3505, 112, 108, 2, 33, "Subsubsection",
  CellTags->"info"],
Cell[3616, 116, 201, 4, 22, "Compact12Text",
  CellTags->"info"],
Cell[3820, 122, 88, 1, 36, "Subsection",
  CellTags->{"ContactInformation", "services"}],
Cell[3911, 125, 154, 2, 33, "Subsubsection",
  CellTags->{"ContactInformation", "services"}],
Cell[4068, 129, 353, 11, 36, "Compact12Text",
  CellTags->"services"],
Cell[4424, 142, 124, 2, 33, "Subsubsection",
  CellTags->"services"],
Cell[4551, 146, 349, 11, 36, "Compact12Text",
  CellTags->"services"],
Cell[4903, 159, 196, 7, 33, "Subsubsection",
  CellTags->"services"],
Cell[5102, 168, 353, 11, 36, "Compact12Text",
  CellTags->"services"],
Cell[5458, 181, 149, 3, 34, "Subsection",
  CellTags->{"ContactInformation", "comments"}],
Cell[5610, 186, 126, 2, 33, "Subsubsection",
  CellTags->{"ContactInformation", "comments"}],
Cell[5739, 190, 365, 11, 36, "Compact12Text",
  CellTags->"comments"],
Cell[6107, 203, 102, 2, 33, "Subsubsection",
  CellTags->"comments"],
Cell[6212, 207, 349, 11, 36, "Compact12Text",
  CellTags->"comments"],
Cell[6564, 220, 112, 2, 33, "Subsubsection",
  CellTags->"comments"],
Cell[6679, 224, 353, 11, 36, "Compact12Text",
  CellTags->"comments"],
Cell[7035, 237, 183, 7, 33, "Subsubsection",
  CellTags->"comments"],
Cell[7221, 246, 640, 19, 122, "Compact12Text",
  CellTags->"comments"],
Cell[7864, 267, 262, 9, 34, "Subsection",
  CellTags->{"ContactInformation", "products"}],
Cell[8129, 278, 216, 7, 33, "Subsubsection",
  CellTags->{"ContactInformation", "products"}],
Cell[8348, 287, 195, 4, 22, "Compact12Text",
  CellTags->"products"],
Cell[8546, 293, 224, 9, 33, "Subsubsection",
  CellTags->"products"],
Cell[8773, 304, 425, 13, 37, "Compact12Text",
  CellTags->"products"],
Cell[9201, 319, 185, 7, 33, "Subsubsection",
  CellTags->"products"],
Cell[9389, 328, 199, 4, 22, "Compact12Text",
  CellTags->"products"],
Cell[9591, 334, 193, 7, 33, "Subsubsection",
  CellTags->"products"],
Cell[9787, 343, 585, 17, 64, "Compact12Text",
  CellTags->"products"],
Cell[10375, 362, 183, 7, 33, "Subsubsection",
  CellTags->"products"],
Cell[10561, 371, 353, 11, 36, "Compact12Text",
  CellTags->"products"],
Cell[10917, 384, 146, 3, 34, "Subsection",
  CellTags->{"ContactInformation", "addresses"}],
Cell[11066, 389, 165, 3, 33, "Subsubsection",
  CellTags->{"ContactInformation", "addresses"}],
Cell[11234, 394, 375, 10, 92, "Compact12Text",
  CellTags->"addresses"],
Cell[11612, 406, 78, 1, 33, "Subsubsection",
  CellTags->"addresses"],
Cell[11693, 409, 437, 12, 106, "Compact12Text",
  CellTags->"addresses"],
Cell[12133, 423, 145, 3, 33, "Subsubsection",
  CellTags->"addresses"],
Cell[12281, 428, 423, 13, 120, "Compact12Text",
  CellTags->"addresses"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

